/*
 * Decompiled with CFR 0.152.
 */
package com.hisroyalty.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.hisroyalty.GachaMachine;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class DatapackConfig
implements SimpleSynchronousResourceReloadListener {
    private static final Codec<Map<String, Integer>> CONFIG_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT);
    private static final Map<String, Integer> gachaMachineCurrencyLimits = new HashMap<String, Integer>();

    public class_2960 getFabricId() {
        return GachaMachine.id("datapack_config");
    }

    public void method_14491(class_3300 resourceManager) {
        gachaMachineCurrencyLimits.clear();
        resourceManager.method_14488("config", path -> path.method_12832().endsWith(".json")).forEach((id, resource) -> {
            if (id.method_12832().equals("config/server_config.json")) {
                try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    DataResult result = CONFIG_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    result.resultOrPartial(System.err::println).ifPresentOrElse(gachaMachineCurrencyLimits::putAll, () -> GachaMachine.LOGGER.warn("Failed to load config for gacha machine: {}", id));
                    GachaMachine.LOGGER.info("Loaded config for gacha machine: {}", id);
                }
                catch (Exception e) {
                    GachaMachine.LOGGER.error("Failed to load config for gacha machine: {}", id, (Object)e);
                }
            }
        });
    }

    public static int getMaxCurrency(String machineId) {
        return gachaMachineCurrencyLimits.getOrDefault(machineId, 5);
    }
}

